
 TBAG32HELP 0W  TPF0
TBag32Help	Bag32HelpLeftzTop WidthHeightCaptionTBag32 Help
Font.ColorclWindowTextFont.Height	Font.Name
MS Sans Serif
Font.Style ScaledShowHint	OnClose	FormCloseOnShowFormShow
PixelsPerInch`
TextHeight
 TPanelPanel1Left Top Width HeightAlignalLeft
BevelOuterbvNoneCaption TabOrder  TListBoxlbTopicsLeft Top Width Height4AlignalClient
Font.ColorclNavyFont.Height	Font.NameArial
Font.StylefsBold 
ItemHeight
ParentFontTabOrder OnClick
lbTopicsClick  TPanelPanel2Left Top Width Height AlignalTop
BevelOuterbvNoneCaption TabOrder TRadioGrouprgTopicsLeftTopWidthuHeight CaptionTopics
Font.ColorclRedFont.Height	Font.NameArial
Font.StylefsBold 
Items.StringsAboutUsage
PropertiesMethodsEvents
Build History 
ParentFontTabOrder OnClick
rgTopicsClick    	TRichEdit	memTopicsLeft Top WidthHeightAlignalClientHideScrollBarsReadOnly	
ScrollBars
ssVerticalTabOrder  TListBoxListBox1Left Top8WidthyHeighta
ItemHeight

Items.Strings{\rtf1\ansi\ansicpg1252\deff0\deftab720{\fonttbl{\f0\fswiss MS Sans Serif;}{\f1\froman\fcharset2 Symbol;}{\f2\fswiss MS Sans Serif;}{\f3\fswiss Arial;}{\f4\fmodern Courier New;}{\f5\fswiss\fprq2 System;}}{\colortbl\red0\green0\blue0;\red255\green0\blue0;\red0\green0\blue128;\red0\green0\blue255;\red0\green128\blue128;\red0\green128\blue0;}V\deflang1033\horzdoc{\*\fchars }{\*\lchars }\pard\li480\ri840\plain\f2\fs12\cf0       H\par \pard\li480\ri840\qc\plain\f3\fs32\cf1\b ===ABOUT===\plain\f4\fs20 %\par \pard\li480\ri840\plain\f4\fs20 A\par \plain\f3\fs24\cf2\b ---ABOUT: TBag32 Version\plain\f4\fs20 \par ?\par \plain\f2\fs24\b Build = 003\plain\f2\fs20\b   (06-Mar-97)\par \par \plain\f4\fs20 \par @\par \plain\f3\fs24\cf2\b ---ABOUT: TBag32 Author\plain\f4\fs20 \par f\par \plain\f3\fs24\cf3\b Mike Orriss\plain\f3\fs20\cf3\b   (3K Computer Consultancy)\plain\f3\fs20\b \par 4\par \plain\f3\fs20\cf3\b e-mail: mjo@compuserve.com\par tel:  +44 (0)1785 824053\par \par \par \plain\f4\fs20 \par E\par \plain\f3\fs24\cf2\b ---ABOUT: TBag32 Source Code\plain\f4\fs20 \par \par \plain\f2\fs20 TBag32 compiled code is free via Compuserve BDelphi forum library 22 (\plain\f2\fs20\cf3 TBAG32.ZIP\plain\f2\fs20 ).\par I\par The full source code is available from Compuserve SWREG for U.S $20.\par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \plain\f4\fs20 H\par \pard\li480\ri840\qc\plain\f3\fs32\cf1\b ===USAGE===\plain\f4\fs20 %\par \pard\li480\ri840\plain\f4\fs20 :\par \plain\f3\fs24\cf2\b ---USAGE: Purpose\plain\f4\fs20 \par i\par \plain\f2\fs20 TBag32 is designed to simplify saving/restoring user settings via the Win32 Registry.\par \par This is achieved via pairs of methods, e.g GetString & SetString. All 'Set' methods are procedures but the 'Get' methods are a mixture of functions and procedures, depending whether the whole object is changing or just one of its properties.\par 6\par For example, compare GetFont and GetFontAndColor:\par \plain\f4\fs20 ;\par \plain\f4\fs20\cf3   SubKey := 'SOFTWARE\\3K\\TEST\\';0\par   Memo1.Font := GetFont('FONT',Memo1.Font);7\par   GetFontAndColor('F_AND_C',Memo1);\plain\f4\fs20 \par \par \plain\f2\fs20 In the first case, the 2nd parameter is the default value and you could use any Font property -  it doesn't have to be Memo1.\par f\par In the second case, Memo1's Font & Color properties will be updated if the registry entry exists.\par \par \par \plain\f4\fs20 :\par \plain\f3\fs24\cf2\b ---USAGE: Typical\plain\f4\fs20 \par \par \plain\f2\fs20 A simple way of using TBag32 is to place the 'Get' methods in Form.Show and the 'Set' methods in Form.Close, e.g assuming that Bag1 is a TBag32 component:\par \plain\f4\fs20 D\par \plain\f4\fs20\cf3  procedure TForm1.FormShow(Sender: TObject);\par  begin\par    with Bag1 do begin)\par      GetFormPlace('FORMPLACE',Self);-\par      Box1.ItemIndex:=GetInteger('LB',0);\par    end;
\par  end;\par L\par  procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);\par  begin\par    with Bag1 do begin*\par      SetInteger('LB',Box1.ItemIndex);)\par      SetFormPlace('FORMPLACE',Self);\par    end;
\par  end;\par \par \plain\f4\fs20 \par @\par \plain\f3\fs24\cf2\b ---USAGE: Registry Keys\plain\f4\fs20 \par A\par \plain\f2\fs20 TBag32 sets the default Registry root key to:\par ;\par   \plain\f2\fs20\cf3 HKEY_CURRENT_USERS\plain\f2\fs20 \par \par and all keys supplied (which may be left blank) to the Get/Set methods are relative to that. For normal purposes this is sufficient but you can change the RootKey property if you wish to  use a different Registry root.\par \par The SubKey property allows you to set a common Registry key, simplifying the statements required. The following sets of statements are logically equivalent:\par %\par \plain\f4\fs20\cf3 SubKey := '';>\par SetString('Software\\3K\\TBag32\\Title','default title');4\par SetBoolean('Software\\3K\\TBag32\\First',True);\par \par SubKey := 'Software\\3K';0\par SetString('TBag32\\Title','default title');&\par SetBoolean('TBag32\\First',True);\par &\par SubKey := 'Software\\3K\\TBag32';(\par SetString('Title','default title');\par SetBoolean('First',True);\par l\par \plain\f2\fs20 Note: as the GetAll method processes multiple keys, it does not use the SubKey property.\par \par \par \plain\f4\fs20 \par 9\par \plain\f3\fs24\cf2\b ---USAGE: GetAll\plain\f4\fs20 \par \par \plain\f2\fs20 The GetAll method is a special case. It allows you to iterate through a section of the Registry  and, by using one or more of the events provided,  you can display the registry contents.\par The \plain\f2\fs20\cf3 TEST.DPR\plain\f2\fs20  demo provided shows how to display via a TreeView using very few lines of code.\par \par Note that the GetStrings method handles all types of Registry entries. Particularly useful is the display of binary entries, which are displayed in \plain\f2\fs20\b binary and character \plain\f2\fs20 format.\par b\par Also note: as the GetAll method processes multiple keys, it does not use the SubKey property.\par \par \plain\f4\fs20 \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par M\par \pard\li480\ri840\qc\plain\f3\fs32\cf1\b ===PROPERTIES===\plain\f4\fs20 %\par \pard\li480\ri840\plain\f4\fs20 <\par \plain\f3\fs24\cf2\b ---PROPERTIES: Name\plain\f4\fs20 \par 5\par \plain\f2\fs20 Standard property.\plain\f4\fs20 \par \par \par ?\par \plain\f3\fs24\cf2\b ---PROPERTIES: RootKey\plain\f4\fs20 \par I\par \plain\f2\fs20 Controls the section of the Registry being processed.\par \par \par >\par \plain\f3\fs24\cf2\b ---PROPERTIES: SubKey\plain\f4\fs20 \par x\par \plain\f2\fs20 Allows you to set a common Registry key. The following pairs of statements are logically equivalent:\par %\par \plain\f4\fs20\cf3 SubKey := '';>\par SetString('Software\\3K\\TBag32\\Title','default title');\par &\par SubKey := 'Software\\3K\\TBag32';(\par SetString('Title','default title');\par \plain\f2\fs20 \par \plain\f4\fs20 \par ;\par \plain\f3\fs24\cf2\b ---PROPERTIES: Tag\plain\f4\fs20 \par \par \plain\f2\fs20 Standard property. Note that this could be used to differentiate between multiple GetAll calls, so that its four events can operate in a different fashion for each call.\plain\f4\fs20 \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par ;\par \pard\li480\ri840\qc\plain\f3\fs32\cf1\b ===METHODS===\par ;  \par \pard\li480\ri840\plain\f2\fs20 All the methods below (with the exception of GetAll) have a first parameter of AName which represents the concatenation of the Registry key, the SubKey property and the identity. TBag32 extracts the last token as the identity, leaving the remainder of AName as the Registry key.\par  \par For example, you might say:\par B\par   \plain\f4\fs20\cf3 SubKey := 'Software\\3K';\plain\f2\fs20 L\par   \plain\f4\fs20\cf3 len := GetInteger(TBag\\Index1',0);\plain\f2\fs20 \par u\par This will extract the value of Index1 for the 'Software\\3K\\TBag' key, returning zero if the key doesn't exist.\par \par \plain\f4\fs20   \par >\par \plain\f3\fs24\cf2\b ---METHODS: Construct\plain\f4\fs20 \par M\par \plain\f4\fs20\cf3 constructor Construct(subkey: string);\plain\f4\fs20 \par \par \plain\f2\fs20 This is a convenient way of creating a TBag32 object at run-time.  Application is the owner of the TBag32 instance created. \par  \par \plain\f4\fs20\cf3 Example:\par =\par   with TBag32.Construct('Software\\3K\\TBag32') do try  1\par     GetStrings('LIST_ITEMS',ListBox1.Items);\par   finally\par     Free;\par   end;\plain\f4\fs20 \par  \par \par   I\par \plain\f4\fs28\cf4 __________________________________\plain\f4\fs28 \par \plain\f3\fs24\cf2\b +\par ---METHODS: GetDataSize\plain\f4\fs20 \par [\par \plain\f4\fs20\cf3 procedure GetDataSize(const AName: string): integer;\plain\f4\fs20 \par \par \plain\f2\fs20 Returns the size of a data value. If the key does not exist, it returns -1. Use this function in order to size the buffer you provide for the GetBinary procedure.\par  \par \plain\f4\fs20\cf3 Example:\par "\par   blen := GetDataSize('Bin');\par   if blen > 0 then begin"\par     buffer := AllocMem(blen);\par     try.\par       blen:=GetBinary('Bin',buffer,blen);\par       // process buffer;\par     finally\par       FreeMem(buffer);
\par     end;\par   end;\plain\f4\fs20 \par  \par \par   I\par \plain\f4\fs28\cf4 __________________________________\plain\f4\fs28 \par \plain\f3\fs24\cf2\b &\par ---METHODS: GetAll\plain\f4\fs20 \par _\par \plain\f4\fs20\cf3 procedure GetAll(const AKey: string; maxlevel: integer);\plain\f4\fs20 \par ~\par \plain\f2\fs20 Iterates through a section of the registry. Place your processing in one or more of its associated events.\par The 'maxlevel' parameter restricts the number of nested levels down the Registry tree that are processed and is provided for performance reasons:\plain\f4\fs20 \par 7\par   \plain\f4\fs20\cf3 GetAll('',99);\plain\f4\fs20 \par ]\par \plain\f2\fs20 on '\plain\f2\fs20\b HKEY_CURRENT_USER\plain\f2\fs20 ' may be a bit slow.\par \plain\f4\fs20 \par   I\par \plain\f4\fs28\cf4 __________________________________\plain\f4\fs28 \par \plain\f4\fs20 \par >\par \plain\f3\fs24\cf2\b ---METHODS: GetBinary\plain\f4\fs20 \par g\par \plain\f4\fs20\cf3 function GetBinary(const AName: string; var Buffer; BufSize: integer): integer;\par \plain\f4\fs20 \par >\par \plain\f3\fs24\cf2\b ---METHODS: SetBinary\plain\f4\fs20 \par n\par \plain\f4\fs20\cf3 procedure SetBinary(const AName: string; var Buffer; BufSize: integer);\plain\f4\fs20 \par I\par \plain\f4\fs28\cf4 __________________________________\plain\f4\fs28 \par \plain\f4\fs20 \par ?\par \plain\f3\fs24\cf2\b ---METHODS: GetBoolean\plain\f4\fs20 \par Y\par \plain\f4\fs20\cf3 function GetBoolean(const AName: string; ADef: Boolean): Boolean;\par \plain\f4\fs20 \par ?\par \plain\f3\fs24\cf2\b ---METHODS: SetBoolean\plain\f4\fs20 \par b\par \plain\f4\fs20\cf3 procedure SetBoolean(const AName: string; AValue: Boolean);\plain\f4\fs20 \par I\par \plain\f4\fs28\cf4 __________________________________\plain\f4\fs28 \par \plain\f4\fs20 \par =\par \plain\f3\fs24\cf2\b ---METHODS: GetColor\plain\f4\fs20 \par T\par \plain\f4\fs20\cf3 function GetColor(const AName: string; const ADef: TColor): \par TColor;\par \plain\f4\fs20 \par =\par \plain\f3\fs24\cf2\b ---METHODS: SetColor\plain\f4\fs20 \par e\par \plain\f4\fs20\cf3 procedure SetColor(const AName: string; const AValue: TColor);\plain\f4\fs20 \par I\par \plain\f4\fs28\cf4 __________________________________\plain\f4\fs28 \par \plain\f4\fs20 \par A\par \plain\f3\fs24\cf2\b ---METHODS: GetFormPlace\plain\f4\fs20 \par X\par \plain\f4\fs20\cf3 procedure GetFormPlace(const AName: string; const AForm: TForm);\par P\par \plain\f2\fs20\cf0 Restores the form to the saved position, size and state.\par !\par \plain\f4\fs20\cf3 Example: \par 0\par procedure TForm1.FormShow(Sender: TObject);
\par begin\par   with Bag1 do begin(\par     GetFormPlace('FORMPLACE',Self);\par   end;	\par end;\par \plain\f4\fs20 \par A\par \plain\f3\fs24\cf2\b ---METHODS: SetFormPlace\plain\f4\fs20 \par g\par \plain\f4\fs20\cf3 procedure SetFormPlace(const AName: string; const AForm: TForm);\plain\f4\fs20 \par \plain\f2\fs20\cf0 /\par Saves the form's position, size and state.\par !\par \plain\f4\fs20\cf3 Example: \par M\par procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
\par begin\par   with Bag1 do begin(\par     SetFormPlace('FORMPLACE',Self);\par   end;\par end;\plain\f4\fs20 \par I\par \plain\f4\fs28\cf4 __________________________________\plain\f4\fs28 \par \plain\f4\fs20 \par <\par \plain\f3\fs24\cf2\b ---METHODS: GetFont\plain\f4\fs20 \par a\par \plain\f4\fs20\cf3 function GetFont(const AName: string; ADef: TFont): TFont;\plain\f4\fs20 \par \par \par <\par \plain\f3\fs24\cf2\b ---METHODS: SetFont\plain\f4\fs20 \par c\par \plain\f4\fs20\cf3 procedure SetFont(const AName: string; const AValue: TFont);\plain\f4\fs20 \par I\par \plain\f4\fs28\cf4 __________________________________\plain\f4\fs28 \par \plain\f4\fs20 \par D\par \plain\f3\fs24\cf2\b ---METHODS: GetFontAndColor\plain\f4\fs20 \par p\par \plain\f4\fs20\cf3 procedure GetFontAndColor(const AName: string; const AComp: TWinControl);\plain\f4\fs20 \par \par \plain\f2\fs20 Many window controls have Font and Color properties and this method is useful for restoring/saving as a single operation. Note that the control must be descended from TControl for this method to work.\par h\par The Font & Color properties are left unchanged if the Registry entry does not exist.\plain\f4\fs20 \par \par D\par \plain\f3\fs24\cf2\b ---METHODS: SetFontAndColor\plain\f4\fs20 \par p\par \plain\f4\fs20\cf3 procedure SetFontAndColor(const AName: string; const AComp: TWinControl);\plain\f4\fs20 \par {\par \plain\f2\fs20 This method saves AComp's Font and Color properties into a single binary registry entry.\plain\f4\fs20 \par I\par \plain\f4\fs28\cf4 __________________________________\plain\f4\fs28 \par \plain\f4\fs20 \par ?\par \plain\f3\fs24\cf2\b ---METHODS: GetInteger\plain\f4\fs20 \par h\par \plain\f4\fs20\cf3 function GetInteger(const AName: string; ADef: integer): integer;\plain\f4\fs20 \par \par ?\par \plain\f3\fs24\cf2\b ---METHODS: SetInteger\plain\f4\fs20 \par b\par \plain\f4\fs20\cf3 procedure SetInteger(const AName: string; AValue: integer);\plain\f4\fs20 \par I\par \plain\f4\fs28\cf4 __________________________________\plain\f4\fs28 \par \plain\f4\fs20 \par >\par \plain\f3\fs24\cf2\b ---METHODS: GetString\plain\f4\fs20 \par \\par \plain\f4\fs20\cf3 function GetString(const AName,ADef: string): string;\plain\f4\fs20 \par E  \par \plain\f2\fs20 The GetString method will handle any kind of Registry entry, returning '\plain\f2\fs20\cf3 <binary L=nnn>\plain\f2\fs20 ' or '\plain\f2\fs20\cf3 <unknown>\plain\f2\fs20 ' for the two datatypes it cannot handle. See GetStrings below in order to display binary data in a TStrings descendant.\plain\f4\fs20  \par \par >\par \plain\f3\fs24\cf2\b ---METHODS: SetString\plain\f4\fs20 \par W\par \plain\f4\fs20\cf3 procedure SetString(const AName,AValue: string);\plain\f4\fs20 \par I\par \plain\f4\fs28\cf4 __________________________________\plain\f4\fs28 \par \plain\f4\fs20 \par ?\par \plain\f3\fs24\cf2\b ---METHODS: GetStrings\plain\f4\fs20 \par c\par \plain\f4\fs20\cf3 procedure GetStrings(const AName: string; AValue: TStrings);\plain\f4\fs20 \par _\par \plain\f2\fs20 This method handles all datatypes in a useful manner except for '<unknown'.\par \par String data is checked for the existence of a comma, ',' and if found, uses the TStrings.CommaText method to split the data into lines.\par G\par Binary data is written 16 bytes to a line in the following format:\par \plain\f4\fs20 N\par \plain\f4\fs16\cf5 000 xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx *............*N\par 010 xxxxxxxx xxxxxxxx xxxxxxxx xxxxxxxx *............*\plain\f4\fs20\cf5 \par \plain\f4\fs20 \par \plain\f2\fs20 where \plain\f2\fs20\cf5 xxxxxx\plain\f2\fs20  is the hex representation followed by the printable characters with non-printable replaced by '.'.\par \plain\f4\fs20 \par \par ?\par \plain\f3\fs24\cf2\b ---METHODS: SetStrings\plain\f4\fs20 \par i\par \plain\f4\fs20\cf3 procedure SetStrings(const AName: string; const AValue: TStrings);\plain\f4\fs20 \par v\par \plain\f2\fs20 This method allows to to save any TStrings descendent into a single Registry entry.\plain\f4\fs20 \par \plain\f4\fs20\cf3 
\par Example:\par .\par   SetStrings('LIST_ITEMS',ListBox.Items);\par \plain\f4\fs20 \par \plain\f4\fs28\cf4 \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \plain\f4\fs20 \par I\par \pard\li480\ri840\qc\plain\f3\fs32\cf1\b ===EVENTS===\plain\f4\fs20 %\par \pard\li480\ri840\plain\f4\fs20 B\par \plain\f3\fs24\cf2\b ---EVENTS: OnBeforeGetAll\plain\f4\fs20 \par G\par \plain\f4\fs20\cf3 OnBeforeGetAll(Sender: TObject);\plain\f4\fs20 \par \par \plain\f2\fs20 This event is fired at the start of the GetAll method. You can use it (and its partner OnAfterGetAll) in order to issue BeginUpdate and AfterUpdate type commands.\par \par Note: you could issue any such commands within your code wrapped around the GetAll call, but these events handle the try/finally/end logic for you, so you don't have to write so much code.\plain\f4\fs20 \par \par \par  <\par \plain\f3\fs24\cf2\b ---EVENTS: OnGetAll\plain\f4\fs20 \par \par \plain\f4\fs20\cf3 OnGetAll(Sender: TObject; const Key: string; Level: integer; const Ident: string; const Value: string; var Continue: boolean);\plain\f4\fs20 \par _\par \plain\f2\fs20 This event fires for each Registry value found during a GetAll method call.\par J  \par Use the 'Level' parameter in harness with the OnGetAllNewLevel event described below. For example, you could manage an array of TTreeNodes and use Level as its index. All Values for a particular Key will be returned sequentially and you can rely on the Level being the same as that from the last fired OnGetAllNewLevel event.\par \par See the demo application, which displays the Registry in a TreeView, together with a TMemo that displays the full contents of the current Registry entry.\par \par \par \plain\f4\fs20 D\par \plain\f3\fs24\cf2\b ---EVENTS: OnGetAllNewLevel\plain\f4\fs20 \par \par \plain\f4\fs20\cf3 OnGetAllNewLevel(Sender: TObject; const Key: string; Level: integer; var Continue: boolean);\plain\f4\fs20 \par !  \par \plain\f2\fs20 This event is fired during GetAll processing every time that a Registry Key is reached for the first time. Thus for the  Key 'Software\\3K\\TBag32\\Test', the event will fire four times, returning 'Software', '3K', 'TBag32' and 'Test' at Level 0 through 3 respectively.\par \par You can save data in array(s) using Level as an index and then use the Level returned by the OnGetAll event to associate with data value(s) returned.\par \par \par \plain\f4\fs20 C\par \plain\f3\fs24\cf2\b ---EVENTS: OnAfterGetAll\plain\f3\fs24\b \par \plain\f4\fs20 F\par \plain\f4\fs20\cf3 OnAfterGetAll(Sender: TObject);\plain\f4\fs20 \par \par \plain\f2\fs20 This event is fired at the end of the GetAll method. You can use it (and its partner OnBeforeGetAll) in order to issue BeginUpdate and EndUpdate type commands.\par \par Note: you could issue any such commands within your code wrapped around the GetAll call, but these events handle the try/finally/end logic for you, so you don't have to write so much code.\par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par P\par \pard\li480\ri840\qc\plain\f3\fs32\cf1\b ===BUILD HISTORY===\plain\f4\fs20 %\par \pard\li480\ri840\plain\f4\fs20 ;\par \plain\f3\fs24\cf2\b ---BUILD HISTORY:  003  06-Mar-97\par \plain\f0\fs20\cf0 X\par TBAG32:  fixed GetStrings bug (stopped losing IDE contents when no Registry entry).\par *\par TBAG32:  added Construct constructor.\par $\par TBAG32:  added SubKey property.\par \plain\f0\fs20\cf2 O\par \plain\f2\fs20\cf0 ABOUT:  replaced REGVIEWA.DFM/PAS with ABOUT3K.DFM/PAS.\par \par ;\par \plain\f3\fs24\cf2\b ---BUILD HISTORY:  002  05-Mar-97\par K\par \plain\f2\fs20\cf0 REGVIEW:  new name for the 'TEST' demo application.\par ,\par TEST:  added 'About' button and screen.\par E\par TEST:  removed Rootkey changes auto-setting Levels=1 (for Phil).\par 9\par TEST:  stopped  'Memo1' from displaying at start-up.\par F\par TEST:  initial display always showed 'HKEY_CURRENT_USER' details.\par @\par TEST:  fixed intermittent 'list index out of bounds' error.\par P\par HELP:  help info now internal to TBag32 (avoids missing TBAGHELP.RTF msg) .\par U\par HELP:  additional blank lines inserted in order to keep main sections separated.\par \par \plain\f4\fs20 ;\par \plain\f3\fs24\cf2\b ---BUILD HISTORY:  001  04-Mar-97\par \par \plain\f2\fs20\cf0 Initial release issued to a few friends only for them to tear it to pieces and ask for all sorts of wonderful new features!\plain\f4\fs20 \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \par \plain\f3\fs20 \par } TabOrderVisible   